/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.test.vcl;

import java.awt.AWTException;
import java.awt.Robot;
import java.util.HashMap;
import java.util.StringTokenizer;

public class Tester {
    static Robot robot;
    protected static HashMap<String, Integer> keyCodeMap;
    protected static HashMap<Character, String[]> keyMap;
    protected static HashMap<String, String[]> customizedMap;

    static {
        try {
            robot = new Robot();
            robot.setAutoDelay(20);
            robot.setAutoWaitForIdle(true);
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
        keyCodeMap = new HashMap();
        keyMap = new HashMap();
        customizedMap = new HashMap();
        keyCodeMap.put("esc", 27);
        keyCodeMap.put("f1", 112);
        keyCodeMap.put("f2", 113);
        keyCodeMap.put("f3", 114);
        keyCodeMap.put("f4", 115);
        keyCodeMap.put("f5", 116);
        keyCodeMap.put("f6", 117);
        keyCodeMap.put("f7", 118);
        keyCodeMap.put("f8", 119);
        keyCodeMap.put("f9", 120);
        keyCodeMap.put("f10", 121);
        keyCodeMap.put("f11", 122);
        keyCodeMap.put("f12", 123);
        keyCodeMap.put("printscreen", 154);
        keyCodeMap.put("scrolllock", 145);
        keyCodeMap.put("pause", 19);
        keyCodeMap.put("tab", 9);
        keyCodeMap.put("space", 32);
        keyCodeMap.put("capslock", 20);
        keyCodeMap.put("shift", 16);
        keyCodeMap.put("ctrl", 17);
        keyCodeMap.put("alt", 18);
        keyCodeMap.put("bs", 8);
        keyCodeMap.put("backspace", 8);
        keyCodeMap.put("enter", 10);
        keyCodeMap.put("cr", 10);
        keyCodeMap.put("command", 157);
        keyCodeMap.put("control", 17);
        keyCodeMap.put("insert", 155);
        keyCodeMap.put("del", 127);
        keyCodeMap.put("delete", 127);
        keyCodeMap.put("home", 36);
        keyCodeMap.put("end", 35);
        keyCodeMap.put("pageup", 33);
        keyCodeMap.put("pagedown", 34);
        keyCodeMap.put("up", 38);
        keyCodeMap.put("left", 37);
        keyCodeMap.put("right", 39);
        keyCodeMap.put("down", 40);
        keyCodeMap.put("numlock", 144);
        keyCodeMap.put("a", 65);
        keyCodeMap.put("b", 66);
        keyCodeMap.put("c", 67);
        keyCodeMap.put("d", 68);
        keyCodeMap.put("e", 69);
        keyCodeMap.put("f", 70);
        keyCodeMap.put("g", 71);
        keyCodeMap.put("h", 72);
        keyCodeMap.put("i", 73);
        keyCodeMap.put("j", 74);
        keyCodeMap.put("k", 75);
        keyCodeMap.put("l", 76);
        keyCodeMap.put("m", 77);
        keyCodeMap.put("n", 78);
        keyCodeMap.put("o", 79);
        keyCodeMap.put("p", 80);
        keyCodeMap.put("q", 81);
        keyCodeMap.put("r", 82);
        keyCodeMap.put("s", 83);
        keyCodeMap.put("t", 84);
        keyCodeMap.put("u", 85);
        keyCodeMap.put("v", 86);
        keyCodeMap.put("w", 87);
        keyCodeMap.put("x", 88);
        keyCodeMap.put("y", 89);
        keyCodeMap.put("z", 90);
        keyCodeMap.put("0", 48);
        keyCodeMap.put("1", 49);
        keyCodeMap.put("2", 50);
        keyCodeMap.put("3", 51);
        keyCodeMap.put("4", 52);
        keyCodeMap.put("5", 53);
        keyCodeMap.put("6", 54);
        keyCodeMap.put("7", 55);
        keyCodeMap.put("8", 56);
        keyCodeMap.put("9", 57);
        keyCodeMap.put("`", 192);
        keyCodeMap.put("-", 45);
        keyCodeMap.put("=", 61);
        keyCodeMap.put("[", 91);
        keyCodeMap.put("]", 93);
        keyCodeMap.put("\\", 92);
        keyCodeMap.put(";", 59);
        keyCodeMap.put("'", 222);
        keyCodeMap.put(",", 44);
        keyCodeMap.put(".", 46);
        keyCodeMap.put("/", 47);
        String chars = "`1234567890-=qwertyuiop[]\\asdfghjkl;'zxcvbnm,./";
        String shiftChars = "~!@#$%^&*()_+QWERTYUIOP{}|ASDFGHJKL:\"ZXCVBNM<>?";
        int i = 0;
        while (i < chars.length()) {
            keyMap.put(Character.valueOf(chars.charAt(i)), new String[]{chars.substring(i, i + 1)});
            keyMap.put(Character.valueOf(shiftChars.charAt(i)), new String[]{"shift", chars.substring(i, i + 1)});
            ++i;
        }
        keyMap.put(Character.valueOf(' '), new String[]{"space"});
        keyMap.put(Character.valueOf('\t'), new String[]{"tab"});
    }

    public static void sleep(double delay) {
        try {
            Thread.sleep((long)(delay * 1000.0));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void click(int x, int y) {
        robot.mouseMove(x, y);
        robot.mousePress(16);
        robot.mouseRelease(16);
        robot.delay(100);
    }

    public static void doubleClick(int x, int y) {
        robot.mouseMove(x, y);
        robot.mousePress(16);
        robot.mouseRelease(16);
        robot.mousePress(16);
        robot.mouseRelease(16);
        robot.delay(100);
    }

    public static void rightClick(int x, int y) {
        robot.mouseMove(x, y);
        robot.mousePress(8);
        robot.mouseRelease(8);
        robot.mousePress(8);
        robot.mouseRelease(8);
        robot.delay(100);
    }

    public static void drag(int fromX, int fromY, int toX, int toY) {
        robot.mouseMove(fromX, fromY);
        robot.mousePress(16);
        int x = fromX;
        int y = fromY;
        int dx = toX > fromX ? 1 : -1;
        int dy = toY > fromY ? 1 : -1;
        while (x != toX || y != toY) {
            if (x != toX) {
                x += dx;
            }
            if (y != toY) {
                y += dy;
            }
            robot.mouseMove(x, y);
        }
        robot.mouseRelease(16);
        robot.delay(100);
    }

    public static void typeText(String text) {
        int i = 0;
        while (i < text.length()) {
            char ch = text.charAt(i);
            String[] shiftKeys = keyMap.get(Character.valueOf(ch));
            if (shiftKeys == null) {
                throw new RuntimeException("Keys is invalid!");
            }
            Tester.typeShortcut(shiftKeys);
            ++i;
        }
    }

    public static void typeShortcut(String ... keys) {
        Integer keyCode;
        String key;
        int i = 0;
        while (i < keys.length) {
            key = keys[i];
            keyCode = keyCodeMap.get(key = key.toLowerCase());
            if (keyCode == null) {
                throw new RuntimeException("Invalid keys!");
            }
            robot.keyPress(keyCode);
            ++i;
        }
        i = keys.length - 1;
        while (i >= 0) {
            key = keys[i];
            keyCode = keyCodeMap.get(key = key.toLowerCase());
            if (keyCode == null) {
                throw new RuntimeException("Invalid keys!");
            }
            robot.keyRelease(keyCode);
            --i;
        }
    }

    public static void typeKeys(String keys) {
        StringTokenizer tokenizer = new StringTokenizer(keys, "<>", true);
        int state = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            switch (state) {
                case 0: {
                    if ("<".equals(token)) {
                        state = 1;
                        break;
                    }
                    if (">".equals(token)) {
                        throw new RuntimeException("Invalid keys!");
                    }
                    Tester.typeText(token);
                    break;
                }
                case 1: {
                    String[] ckeys;
                    if (">".equals(token)) {
                        state = 0;
                        break;
                    }
                    if ("<".equals(token)) {
                        throw new RuntimeException("Invalid keys!");
                    }
                    if (token.startsWith("$")) {
                        ckeys = customizedMap.get(token.substring(1));
                        if (ckeys == null || ckeys.length == 0) {
                            throw new RuntimeException(String.valueOf(token) + " is not a customized shortcut!");
                        }
                        Tester.typeShortcut(ckeys);
                        break;
                    }
                    ckeys = token.split(" ");
                    Tester.typeShortcut(ckeys);
                }
            }
        }
    }

    public static void setCustomizedShortcut(String name, String ... keys) {
        customizedMap.put(name, keys);
    }

    public static void main(String[] args) {
        Tester.sleep(3.0);
        Tester.typeKeys("\t ");
    }
}

