/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.test.vcl.widgets;

import java.util.Properties;
import org.openoffice.test.common.FileUtil;
import org.openoffice.test.common.SystemUtil;
import org.openoffice.test.vcl.Tester;
import org.openoffice.test.vcl.client.VclHook;

public class VclApp {
    String home = null;
    public static final String CMD_KILL_WINDOWS = "taskkill /F /IM soffice.bin /IM soffice.exe";
    public static final String CMD_KILL_LINUX = "killall -9 soffice soffice.bin";
    String cmdKill = null;
    String cmdStart = null;
    String versionFile = null;
    Properties version = null;
    String port = System.getProperty("openoffice.automation.port", "12479");
    private static final int CONST_WSTimeout = 701;

    public VclApp(String appHome) {
        this.setHome(appHome);
    }

    public VclApp() {
        this(null);
    }

    public void setHome(String home) {
        this.home = home;
        if (home == null) {
            home = System.getProperty("openoffice.home");
        }
        if (home == null) {
            home = System.getenv("OPENOFFICE_HOME");
        }
        if (home == null) {
            home = "unkown";
        }
        this.versionFile = "versionrc";
        this.cmdKill = CMD_KILL_LINUX;
        this.cmdStart = "cd \"" + home + "\" ; ./soffice";
        if (SystemUtil.isWindows()) {
            this.cmdKill = CMD_KILL_WINDOWS;
            this.cmdStart = "\"" + home + "\\soffice.exe\"";
            this.versionFile = "version.ini";
        } else {
            SystemUtil.isMac();
        }
    }

    public String getHome() {
        return this.home;
    }

    public void kill() {
        SystemUtil.execScript(this.cmdKill, false);
    }

    public int start(String args) {
        if (args == null) {
            args = "";
        }
        return SystemUtil.execScript(String.valueOf(this.cmdStart) + " -norestore -quickstart=no -nofirststartwizard -enableautomation -automationport=" + this.port + " " + args, true);
    }

    public void start() {
        this.start(null);
    }

    public void activateDoc(int i) {
        VclHook.invokeCommand(2074, i + 1);
    }

    public void reset() {
        VclHook.invokeCommand(6659);
    }

    public boolean existsSysDialog() {
        return (Boolean)VclHook.invokeCommand(2586);
    }

    public void closeSysDialog() {
        VclHook.invokeCommand(2071);
    }

    public String getClipboard() {
        return (String)VclHook.invokeCommand(6657);
    }

    public void setClipboard(String content) {
        VclHook.invokeCommand(6146, content);
    }

    public boolean exists() {
        return VclHook.available();
    }

    public boolean exists(double iTimeout) {
        return this.exists(iTimeout, 1.0);
    }

    public boolean exists(double iTimeout, double interval) {
        long startTime = System.currentTimeMillis();
        while ((double)(System.currentTimeMillis() - startTime) < iTimeout * 1000.0) {
            if (this.exists()) {
                return true;
            }
            Tester.sleep(interval);
        }
        return this.exists();
    }

    public void waitForExistence(double iTimeout, double interval) {
        if (!this.exists(iTimeout, interval)) {
            throw new RuntimeException("OpenOffice is not found!");
        }
    }

    public int getDocCount() {
        return (Integer)VclHook.invokeCommand(2599);
    }

    public Properties getVersion() {
        if (this.version == null) {
            this.version = FileUtil.loadProperties(String.valueOf(this.home) + "/" + this.versionFile);
        }
        return this.version;
    }

    public void dispatch(String url) {
        VclHook.invokeUNOSlot(url);
    }

    public void dispatch(String url, double time) {
        VclHook.invokeUNOSlot(url);
        int result = (Integer)VclHook.invokeCommand(2604, (int)time * 1000);
        if (result == 701) {
            throw new RuntimeException("Timeout to execute the dispatch!");
        }
    }
}

