/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.test.common;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;

public class FileUtil {
    private static final DateFormat FILENAME_FORMAT = new SimpleDateFormat("yyMMddHHmm");

    private FileUtil() {
    }

    public static Document parseXML(String path) {
        try {
            DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
            dbfac.setNamespaceAware(true);
            DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
            return docBuilder.parse(path);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getStringByXPath(String xml, String xpathStr) {
        Document doc = FileUtil.parseXML(xml);
        if (doc == null) {
            return null;
        }
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            XPathExpression expr = xpath.compile(xpathStr);
            return expr.evaluate(doc);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void updateProperty(String file, String key, String value) {
        Properties map = new Properties();
        map.put(key, value);
        FileUtil.updateProperty(file, map);
    }

    public static void updateProperty(String file, Properties props) {
        Properties properties = FileUtil.loadProperties(file);
        properties.putAll((Map<?, ?>)props);
        FileUtil.storeProperties(file, properties);
    }

    public static Properties loadProperties(String file) {
        Properties properties;
        block12: {
            properties = new Properties();
            FileInputStream fis = null;
            try {
                try {
                    fis = new FileInputStream(file);
                    properties.load(fis);
                }
                catch (IOException iOException) {
                    if (fis == null) break block12;
                    try {
                        fis.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return properties;
    }

    public static void storeProperties(String file, Properties properties) {
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(file);
                properties.store(fos, "Generated By PropertyFileUtils");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void deleteProperty(String file, String key) {
        Properties properties = FileUtil.loadProperties(file);
        properties.remove(key);
        FileUtil.storeProperties(file, properties);
    }

    public static String readFileAsString(String file) {
        return FileUtil.readFileAsString(new File(file));
    }

    public static String readFileAsString(File file) {
        StringBuffer strBuffer;
        block15: {
            strBuffer = new StringBuffer(10240);
            BufferedReader reader = null;
            try {
                try {
                    reader = new BufferedReader(new FileReader(file));
                    char[] buf = new char[1024];
                    int count = 0;
                    while ((count = reader.read(buf)) != -1) {
                        strBuffer.append(buf, 0, count);
                    }
                }
                catch (IOException iOException) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return strBuffer.toString();
    }

    public static File findFile(File dir, String name) {
        if (!dir.isDirectory()) {
            return null;
        }
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                File ret = FileUtil.findFile(files[i], name);
                if (ret != null) {
                    return ret;
                }
            } else if (files[i].getName().matches(name)) {
                return files[i];
            }
            ++i;
        }
        return null;
    }

    public static File findLastFile(File dir, String name) {
        if (!dir.isDirectory()) {
            return null;
        }
        File[] files = dir.listFiles();
        File file = null;
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                File ret = FileUtil.findFile(files[i], name);
                if (ret != null) {
                    file = ret;
                }
            } else if (files[i].getName().matches(name)) {
                file = files[i];
            }
            ++i;
        }
        return file;
    }

    public static File findFile(String dirs, String name) {
        String[] directories;
        String[] stringArray = directories = dirs.split(";");
        int n = directories.length;
        int n2 = 0;
        while (n2 < n) {
            File file;
            String s = stringArray[n2];
            File dir = new File(s);
            if (dir.exists() && (file = FileUtil.findFile(dir, name)) != null) {
                return file;
            }
            ++n2;
        }
        return null;
    }

    public static File findLastFile(String dirs, String name) {
        String[] directories;
        String[] stringArray = directories = dirs.split(";");
        int n = directories.length;
        int n2 = 0;
        while (n2 < n) {
            File file;
            String s = stringArray[n2];
            File dir = new File(s);
            if (dir.exists() && (file = FileUtil.findLastFile(dir, name)) != null) {
                return file;
            }
            ++n2;
        }
        return null;
    }

    public static File findDir(String dir, String dirName) {
        File[] files = new File(dir).listFiles();
        int i = 0;
        while (i < files.length) {
            if (!files[i].isDirectory()) {
                File ret = FileUtil.findFile(files[i], dirName);
                if (ret != null) {
                    return ret;
                }
            } else if (files[i].getName().matches(dirName)) {
                return files[i];
            }
            ++i;
        }
        return null;
    }

    public static void writeStringToFile(String filePath, String contents) {
        block13: {
            OutputStreamWriter writer = null;
            try {
                try {
                    File file = new File(filePath);
                    file.getParentFile().mkdirs();
                    writer = new FileWriter(file);
                    if (contents != null) {
                        writer.write(contents);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (writer == null) break block13;
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public static void appendStringToFile(String file, String contents) {
        block12: {
            FileWriter writer = null;
            try {
                try {
                    writer = new FileWriter(file, true);
                    writer.write(contents);
                }
                catch (IOException e) {
                    System.out.println("Warning:" + e.getMessage());
                    if (writer == null) break block12;
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public static void replace(String file, String expr, String substitute) {
        String str = FileUtil.readFileAsString(file);
        str = str.replaceAll(expr, substitute);
        FileUtil.writeStringToFile(file, str);
    }

    public static boolean copyDir(String fromDirName, String toDirName) {
        return FileUtil.copyDir(new File(fromDirName), new File(toDirName), true);
    }

    public static boolean copyDir(File fromDir, File toDir, boolean recursive) {
        if (!fromDir.exists() || !fromDir.isDirectory()) {
            System.err.println("The source dir doesn't exist, or isn't dir.");
            return false;
        }
        if (toDir.exists() && !toDir.isDirectory()) {
            return false;
        }
        boolean result = true;
        toDir.mkdirs();
        File[] files = fromDir.listFiles();
        int i = 0;
        while (i < files.length) {
            result = files[i].isDirectory() && recursive ? (result &= FileUtil.copyDir(files[i], new File(toDir, files[i].getName()), true)) : (result &= FileUtil.copyFile(files[i], toDir));
            ++i;
        }
        return result;
    }

    public static boolean copyFile(File fromFile, File toFile) {
        if (!(fromFile.exists() && fromFile.isFile() && fromFile.canRead())) {
            System.err.println(String.valueOf(fromFile.getAbsolutePath()) + "doesn't exist, or isn't file, or can't be read");
            return false;
        }
        if (toFile.isDirectory()) {
            toFile = new File(toFile, fromFile.getName());
        }
        FileInputStream from = null;
        FileOutputStream to = null;
        try {
            int bytesRead;
            from = new FileInputStream(fromFile);
            File p = toFile.getParentFile();
            if (p != null && !p.exists()) {
                p.mkdirs();
            }
            to = new FileOutputStream(toFile);
            byte[] buffer = new byte[4096];
            while ((bytesRead = from.read(buffer)) != -1) {
                to.write(buffer, 0, bytesRead);
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        finally {
            if (from != null) {
                try {
                    from.close();
                }
                catch (IOException iOException) {}
            }
            if (to != null) {
                try {
                    to.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean copyFile(String fromFileName, String toFileName) {
        return FileUtil.copyFile(new File(fromFileName), new File(toFileName));
    }

    public static boolean copyFiles(String fromDirName, String toDirName) {
        boolean res = true;
        File fromDir = new File(fromDirName);
        if (!(fromDir.exists() && fromDir.isDirectory() && fromDir.canRead())) {
            System.err.println(String.valueOf(fromDir.getAbsolutePath()) + "doesn't exist, or isn't file, or can't be read");
            return false;
        }
        File[] files = fromDir.listFiles();
        int i = 0;
        while (i < files.length) {
            res = files[i].isDirectory() ? res && FileUtil.copyDir(String.valueOf(fromDirName) + "/" + files[i].getName(), String.valueOf(toDirName) + "/" + files[i].getName()) : res && FileUtil.copyFile(String.valueOf(fromDirName) + "/" + files[i].getName(), String.valueOf(toDirName) + "/" + files[i].getName());
            ++i;
        }
        return res;
    }

    public static boolean deleteFile(File path) {
        if (!path.exists()) {
            return true;
        }
        if (path.isDirectory()) {
            File[] files = path.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    FileUtil.deleteFile(files[i]);
                } else {
                    files[i].delete();
                }
                ++i;
            }
        }
        return path.delete();
    }

    public static boolean deleteFile(String path) {
        return FileUtil.deleteFile(new File(path));
    }

    public static boolean fileExists(String file) {
        return new File(file).exists();
    }

    public static String getFileExtName(String file) {
        if (file == null) {
            return null;
        }
        int i = file.lastIndexOf(46);
        if (i < 0 && i >= file.length() - 1) {
            return null;
        }
        return file.substring(i + 1);
    }

    public static long getFileSize(String filePath) {
        long totalSize = 0L;
        FileInputStream f = null;
        File file = new File(filePath);
        try {
            f = new FileInputStream(file);
            totalSize = f.available();
            f.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return totalSize / 1000L;
    }

    public static long getFolderSize(String dir) {
        long totalSize = 0L;
        File[] files = new File(dir).listFiles();
        int i = 0;
        while (i < files.length) {
            totalSize = files[i].isDirectory() ? (totalSize += FileUtil.getFolderSize(files[i].getAbsolutePath()) * 1000L) : (totalSize += files[i].length());
            ++i;
        }
        return totalSize / 1000L;
    }

    public static void unzipFile(String unzipfile, String unzipDest) {
        try {
            ZipEntry entry;
            File dest = new File(unzipDest);
            ZipInputStream zin = new ZipInputStream(new FileInputStream(unzipfile));
            while ((entry = zin.getNextEntry()) != null) {
                if (entry.isDirectory()) {
                    File directory = new File(dest, entry.getName());
                    if (!directory.exists() && !directory.mkdirs()) {
                        System.exit(0);
                    }
                    zin.closeEntry();
                }
                if (entry.isDirectory()) continue;
                File myFile = new File(entry.getName());
                FileOutputStream fout = new FileOutputStream(String.valueOf(unzipDest) + "/" + myFile.getPath());
                DataOutputStream dout = new DataOutputStream(fout);
                byte[] b = new byte[1024];
                int len = 0;
                while ((len = zin.read(b)) != -1) {
                    dout.write(b, 0, len);
                }
                dout.close();
                fout.close();
                zin.closeEntry();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println(e);
        }
    }

    public static File getUniqueFile(File dir, String prefix, String suffix) {
        String name = String.valueOf(prefix) + "." + FILENAME_FORMAT.format(new Date()) + ".";
        int i = 0;
        while (i < Integer.MAX_VALUE) {
            File file = new File(dir, String.valueOf(name) + i + suffix);
            if (!file.exists()) {
                return file;
            }
            ++i;
        }
        return null;
    }

    public static File getUniqueFile(String dir, String prefix, String suffix) {
        return FileUtil.getUniqueFile(new File(dir), prefix, suffix);
    }

    public static File download(String urlString, File output) {
        InputStream in = null;
        OutputStream out = null;
        System.out.println("[Vclauto] Download '" + urlString + "'");
        try {
            URL url = new URL(urlString);
            URLConnection urlConnection = url.openConnection();
            int totalSize = urlConnection.getContentLength();
            in = urlConnection.getInputStream();
            if (output.isDirectory()) {
                output = new File(output, url.getPath());
                output.getParentFile().mkdirs();
            }
            out = new FileOutputStream(output);
            byte[] buffer = new byte[102400];
            int count = 0;
            int totalCount = 0;
            int progress = 0;
            while ((count = in.read(buffer)) > 0) {
                int nowProgress;
                out.write(buffer, 0, count);
                if (totalSize <= 0 || (nowProgress = (totalCount += count) * 10 / totalSize) <= progress) continue;
                progress = nowProgress;
                System.out.print(".");
            }
            System.out.println("Done!");
            File file = output;
            return file;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Error!");
            return null;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

